<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Plan extends Model 
{

    protected $table = 'plans';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'description', 'price', 'currency');

    public function dreams()
    {
        return $this->hasMany('App\Models\Dream');
    }

}